#include "common.h"
void open_link(str url) {
    #ifdef ANDROID
    JNIEnv * env = al_android_get_jni_env();
    jclass class_id = (* env)->GetObjectClass(env, al_android_get_activity());
    jmethodID method_id = (* env)->GetMethodID(env, class_id, "openUrl", "(Ljava/lang/String;)V");
    jstring jdata = (* env)->NewStringUTF(env, url);
    (* env)->CallVoidMethod(env, al_android_get_activity(), method_id, jdata);
    (* env)->DeleteLocalRef(env, jdata);
    (* env)->DeleteLocalRef(env, class_id);
    #else
    print("would open link %s", url);
    #endif
    #ifdef LINUX
    char * s = land_strdup("");
    land_append(& s, "xdg-open %s", url);
    system(s);
    land_free(s);
    #endif
    #ifdef MAOS
    char * s = land_strdup("");
    land_append(& s, "open %s", url);
    system(s);
    land_free(s);
    #endif
    #ifdef WINDOWS
    char * s = land_strdup("");
    land_append(& s, "start %s", url);
    system(s);
    land_free(s);
    #endif
    return ;
}
